 ; Ŀ
 ;   Lineup - make sure that lines are upright.  Intended for use either   
 ;   with composite linetypes containing text, or by the very finicky.     
 ;   Copyright 1996 by Rocket Software                                     
 ;   Batman could have done a lot more good by going after idiots          
 ;   rather than criminals.                                                
 ; 

 ; Ŀ
 ;   Subroutine Lineup: see if a line is upside down, fix it if so.        
 ; 
 (DEFUN LINEUP (enam / entt tenp ten elvp elv angg)
  (setq entt (entget enam))
  (setq ten (cdr (setq tenp (assoc 10 entt))))
  (setq elv (cdr (setq elvp (assoc 11 entt))))
  (setq angg (angle ten elv))
 ; Ŀ
 ;   If line would be upside down then swap ends.                          
 ; 
  (if (and (> angg (/ pi 2)) (<= angg (* pi 1.5)))
      (progn
           (setq entt (subst (cons 11 ten) elvp entt))
           (entmod (subst (cons 10 elv) tenp entt))))
 (princ))
 ; Ŀ
 ;   Lineup end.                                                           
 ; 

 ; Ŀ
 ;   Lineup.                                                               
 ; 
 (DEFUN C:LINEUP (/ ss num enam)
  (setvar "cmdecho" 0)
  (command "undo" "m")
  (write-line "Select lines or <Return> for all: ")
  (setq ss (ssget (list (cons 0 "line"))))
  (if (null ss) (setq ss (ssget "X" (list (cons 0 "line")))))
  (setq num 0)
  (while (and ss (setq enam (ssname ss num)))
         (grtext -2 (itoa (setq num (1+ num))))
         (lineup enam))
 (princ))